#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "SAP2016 Secundaria RAW2 NOPII" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
table(mydata$Seccion)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#'# Direct PII: variables to be removed

# !!!Include any Direct PII variables
dropvars <- c("A_NOM",
              "C_NOM",
              "A_APEPAT",
              "C_APEPAT",
              "A_APEMAT",
              "C_APEMAT",
              "J_DNI",
              "L_DNI") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Direct PII-team: Encode field team names

# !!! Removed as it contains identifying information
dropvars <- c("DIGITA") 
mydata <- mydata[!names(mydata) %in% dropvars]

# !!!Replace vector in "variables" field below with relevant variable names
mydata <- encode_direct_PII_team (variables=c("ENCUES"))

#'# Small locations: Encode locations  with pop <100,000 using random large numbers

# !!! Removed as it contains identifying information
dropvars <- c("NOMESC") 
mydata <- mydata[!names(mydata) %in% dropvars]

#  !!!Include relevant variables, but check their population size first to confirm they are <100,000
locvars <- c("CODLOC", "CODMOD") 
mydata <- encode_location (variables= locvars, missing=999999)

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

dropvars <- c("D_DD",
              "D_MM",
              "F_DD",
              "F_MM") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("NIVESC",
                  "G_SEXO",
                  "I_SEXO",
                  "Q42_1",
                  "Q42_2",
                  "Q42_3",
                  "Q42_4",
                  "Q43")

capture_tables (indirect_PII)

# Recode those with very specific values. 
# !!! No very specific values

#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary

# !!! Identify open-end variables here: 
open_ends <- c("Q11_B",
               "Q12_B",
               "Q17_B",
               "Q18_B",
               "Q23B",
               "Q23D")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
# !!! Remove, as they contain a lot of sensitive information and they are in Spanish.
mydata <- mydata[!names(mydata) %in% "Q11_B"]
mydata <- mydata[!names(mydata) %in% "Q12_B"]
mydata <- mydata[!names(mydata) %in% "Q17_B"]
mydata <- mydata[!names(mydata) %in% "Q18_B"]
mydata <- mydata[!names(mydata) %in% "Q23B"]
mydata <- mydata[!names(mydata) %in% "Q23D"]

#'# GPS data: Displace
# !!! No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
